#####Survival analysis VDV-1 and DWV####

##########from day 0 p.i.###############

mort<- read.table("Cage experiment data 0d.txt", header=T)
View(mort)
mort$treat <- factor(mort$treat, levels=c('M', 'V', 'D', 'C'))

plot(survfit(Surv(dpi, status) ~ treat ,data=mort),ylab="Survival",xlab="Days p.i.",col=c(1,4,2,3),lty=c(1:1), lwd=(2:2))
plot(survfit(model1),ylab="Survival",xlab="Days p.i.")
legend("topright", c("Mix", "VDV", "DWV", "Control"), col=c(1,4,2,3),lty=c(1:1)) 

###median lethal time (t50)
a<-Surv(mort$dpi,mort$status)~mort$treat
survfit(a)


#plot survival curves
##use coxph without colony random term
vCox <- coxph(Surv(dpi, status) ~ as.factor(treat), data=mort)
plot(survfit(vCox), col='white')
lines(survfit(vCox,newdata=data.frame(treat="Control")),col='black')
lines(survfit(vCox,newdata=data.frame(treat="DWV")),col='blue')
lines(survfit(vCox,newdata=data.frame(treat="VDV-1")),col='green')
lines(survfit(vCox,newdata=data.frame(treat="MIX")),col='orange')

termplot(vCox, se=TRUE)

# incorporate 'colony' as random effect
##use coxme
model1 <- coxme(Surv(dpi, status) ~ treat + (1|cage),data=mort)
summary(model1)
print(model1)
AIC(model1)
anova(model1)

modelnull <- coxme(Surv(dpi, status) ~ 1 + (1|cage),data=mort)
anova(model1,modelnull)
print(modelnull)

summary(glht(model1, linfct=mcp(treat ="Tukey")))
m<-summary(glht(model1, linfct=mcp(treat ="Tukey")))
##bonferroni correction
summary(m,test=adjusted(type="bonferroni"))


##########from day 13 p.i.###############

mort13<- read.table("Cage experiment data 13d.txt", header=T)
View(mort13)
mort$treat <- factor(mort$treat, levels=c('M', 'V', 'D', 'C'))

plot(survfit(Surv(dpi_13, status) ~ treat ,data=mort13),ylab="Survival",xlab="Days p.i.",col=c(1,4,2,3),lty=c(1:1), lwd=(2:2))
plot(survfit(model1_13),ylab="Survival",xlab="Days p.i.")
legend("topright", c("Mix", "VDV", "DWV", "Control"), col=c(1,4,2,3),lty=c(1:1)) 
###to get the median lethal time (t50)
a13<-Surv(mort13$dpi_13,mort$status)~mort13$treat
survfit(a13)


#plot survival curves
##use coxph without colony random term
vCox13 <- coxph(Surv(dpi_13, status) ~ as.factor(treat), data=mort13)
plot(survfit(vCox13), col='white')
lines(survfit(vCox13,newdata=data.frame(treat="Control")),col='black')
lines(survfit(vCox13,newdata=data.frame(treat="DWV")),col='blue')
lines(survfit(vCox13,newdata=data.frame(treat="VDV-1")),col='green')
lines(survfit(vCox13,newdata=data.frame(treat="MIX")),col='orange')

termplot(vCox, se=TRUE)


# incorporate 'colony' as random effect
##use coxme
model1_13 <- coxme(Surv(dpi_13, status) ~ treat + (1|cage),data=mort13)
summary(model1_13)
print(model1_13)
AIC(model1_13)
anova(model1_13)

modelnull13 <- coxme(Surv(dpi_13, status) ~ 1 + (1|cage),data=mort13)
anova(model1_13,modelnull13)
print(modelnull13)

summary(glht(model1_13, linfct=mcp(treat ="Tukey")))
m<-summary(glht(model1_13, linfct=mcp(treat ="Tukey")))
##bonferroni correction
summary(m,test=adjusted(type="bonferroni"))



### Plot virus loads
D_dwv_9<-c(176569565921.80, 414617806383.81, 212221814165.47, 302548758497.88, 99653859170.76)
V_vdv_9<-c(2920480607485.87, 2901401640057.17, 2820652080550.68, 1280784021269.72, 6424227863871.44)
wilcox.test(D_dwv_9, V_vdv_9)

D_mix_9<-c(504504218346.07, 1699703416392.77, 692417826596.36, 925610286072.58, 1285922177392.84)
V_mix_9<-c(1645366097189.03, 4607122304117.58, 2949987704299.03, 2897697469151.58, 3892980228102.32)
wilcox.test(D_mix_9, V_mix_9)

D_dwv_13<-c(195511930427.82, 683595893151.01, 391146603892.63)
V_vdv_13<-c(396656612110.95, 566967760401.87, 1116755448574.56)
wilcox.test(D_dwv_13, V_vdv_13)

D_mix_13<-c(406282317906.32, 962219268280.72, 533357594158.83)
V_mix_13<-c(375004409986.09, 722585275438.26, 355406511228.20)
wilcox.test(D_mix_13, V_mix_13)

